/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.trial;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import java.util.ArrayList;

public class AbstractTrial {
    public String name;
    public AbstractPlayer.PlayerClass c;
    public int energy;
    public CardGroup deck;
    public int hp;
    public ArrayList<AbstractRelic> relics = new ArrayList();
    private float x;
    private float y;
    private Hitbox hb;

    public AbstractTrial(String name, AbstractPlayer.PlayerClass c, int hp, int e) {
        this.name = name;
        this.c = c;
        this.hp = hp;
        this.energy = e;
        this.hb = new Hitbox(FontHelper.getSmartWidth(FontHelper.topPanelInfoFont, name, 9999.0f, 0.0f), 32.0f * Settings.scale);
    }

    public void update(float x, float y) {
        this.x = x;
        this.y = y;
        this.hb.move(x + this.hb.width / 2.0f, y);
        this.hb.update();
        if (this.hb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (this.hb.hovered && InputHelper.justClickedLeft && !CardCrawlGame.mainMenuScreen.isFadingOut) {
            CardCrawlGame.mainMenuScreen.trial.startTrial(this);
        }
    }

    public void render(SpriteBatch sb) {
        if (this.hb.hovered) {
            FontHelper.renderSmartText(sb, FontHelper.topPanelInfoFont, this.name, this.x, this.y, 9999.0f, 0.0f, Settings.BLUE_TEXT_COLOR);
        } else {
            FontHelper.renderSmartText(sb, FontHelper.topPanelInfoFont, this.name, this.x, this.y, 9999.0f, 0.0f, Settings.CREAM_COLOR);
        }
        this.hb.render(sb);
    }
}

